/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.surveillance;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.CECStateInformation;
import com.ibm.hsc.auiml.databeans.sfp.data.SFPSettingsInformation;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.surveillance.SurveillanceConstants;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.io.Serializable;
import java.util.HashMap;

public class SurveillanceBean
extends WizardTaskBean
implements SurveillanceConstants {
    private ActionDescriptor[] m_adSurveillanceMenu;
    private double m_dSurveillanceDisconnectedTimer;
    private double m_dSurveillanceConnectedTimer;
    private double m_dSurveillanceOutageIntervalTimer;
    private ItemDescriptor[] m_idSurveillanceCECTable;
    private ColumnDescriptor[] m_cdSurveillanceCECTableStructure;
    private int[] m_iSurveillanceCECTableSelection;
    private SFPSettingsInformation surveillanceSettings;
    private int machineCount = 0;
    public static final String SURVEILLANCE_CEC_TABLE_NAME = "SurveillanceCECTable";
    public static final String SURVEILLANCE_CONNECTED_NAME = "SurveillanceConnectedTimer";
    public static final String SURVEILLANCE_DISCONNECTED_NAME = "SurveillanceDisconnectedTimer";
    public static final String SURVEILLANCE_INTERVAL_NAME = "SurveillanceOutageIntervalTimer";
    public static final String OK_BUTTON = "OK";
    private static final String ENABLED_EN_US = "Enabled";
    private static final String DISABLED_EN_US = "Disabled";
    public static final int MACHINE_NAME_COLUMN = 0;
    public static final int STATE_COLUMN = 1;
    public static final int MACHINE_ID_COLUMN = 2;
    private int initialDisconnected;
    private int initialConnected;
    private int initialInterval;
    private String ENABLED_LABEL = "";
    private String DISABLED_LABEL = "";
    private static HashMap SURVEILLANCE_CHOICES = new HashMap(3);
    private static HashMap ALL_CHOICES = new HashMap(3);
    private static final String TRACE_MASKD = "JIWZSURD";
    private static final String TRACE_MASKF = "JIWZSURF";
    private static final String TRACE_MASKT = "JIWZSURT";

    public SurveillanceBean(Object object) throws WizardTaskException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceBean(settings)");
        }
        this.surveillanceSettings = (SFPSettingsInformation)object;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceBean(settings)");
        }
    }

    public void prepare() {
        block6: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "->SurveillanceBean.prepare()");
            }
            this.ENABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "ENABLED_LBL", ENABLED_EN_US);
            this.DISABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "DISABLED_LBL", DISABLED_EN_US);
            try {
                if (this.surveillanceSettings.panelName.equals("SFPLanSurveillance1")) {
                    this.populateChoices1();
                } else {
                    this.populateChoices2();
                }
            }
            catch (SFPException sFPException) {
                if (3 > Trace.LEVEL) break block6;
                Trace.trace(TRACE_MASKD, "SurveillanceBean.prepare() caught SFPException: " + sFPException.toString());
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceBean.prepare()");
        }
    }

    public double getSurveillanceDisconnectedTimer() {
        return this.m_dSurveillanceDisconnectedTimer;
    }

    public void setSurveillanceDisconnectedTimer(double d) throws IllegalUserDataException {
        this.m_dSurveillanceDisconnectedTimer = d;
    }

    public double getSurveillanceConnectedTimer() {
        return this.m_dSurveillanceConnectedTimer;
    }

    public void setSurveillanceConnectedTimer(double d) throws IllegalUserDataException {
        this.m_dSurveillanceConnectedTimer = d;
    }

    public double getSurveillanceOutageIntervalTimer() {
        return this.m_dSurveillanceOutageIntervalTimer;
    }

    public void setSurveillanceOutageIntervalTimer(double d) throws IllegalUserDataException {
        this.m_dSurveillanceOutageIntervalTimer = d;
    }

    public ColumnDescriptor[] getSurveillanceCECTableRowStructure() {
        return this.m_cdSurveillanceCECTableStructure;
    }

    public int getSurveillanceCECTableRowStatus() {
        return 3;
    }

    public int getSurveillanceCECTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getSurveillanceCECTableRowAt(int n) {
        return this.m_idSurveillanceCECTable;
    }

    public void setSurveillanceCECTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idSurveillanceCECTable = itemDescriptorArray;
    }

    public int[] getSurveillanceCECTableSelection() {
        return this.m_iSurveillanceCECTableSelection;
    }

    public void setSurveillanceCECTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iSurveillanceCECTableSelection = nArray;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void beanInit() throws WizardTaskException {
    }

    private UserTaskManager getUTM() {
        UserTaskManager userTaskManager = this.getUserTaskManager();
        return userTaskManager;
    }

    private void saveChoices1() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceBean.saveChoices1()");
        }
        try {
            this.surveillanceSettings.disconnected = Integer.parseInt(this.getUTM().getValue(this.getMountPrefix() + SURVEILLANCE_DISCONNECTED_NAME));
            this.surveillanceSettings.connected = Integer.parseInt(this.getUTM().getValue(this.getMountPrefix() + SURVEILLANCE_CONNECTED_NAME));
            this.surveillanceSettings.interval = Integer.parseInt(this.getUTM().getValue(this.getMountPrefix() + SURVEILLANCE_INTERVAL_NAME));
            if (this.surveillanceSettings.disconnected != this.initialDisconnected || this.surveillanceSettings.connected != this.initialConnected || this.surveillanceSettings.interval != this.initialInterval) {
                this.surveillanceSettings.pendingChanges = true;
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Timer settings: \n disconnect:" + this.surveillanceSettings.disconnected);
                Trace.trace(TRACE_MASKD, "\n connected: " + this.surveillanceSettings.connected);
                Trace.trace(TRACE_MASKD, "\n interval: " + this.surveillanceSettings.interval);
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SurveillanceBean.saveChoices1() caught Exception " + exception);
                Trace.trace(TRACE_MASKF, "SurveillanceBean.saveChoices1() throwing SFPException");
            }
            throw new SFPException("1100", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceBean.saveChoices1()");
        }
    }

    private void saveChoices2() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceBean.saveChoices2()");
        }
        try {
            this.surveillanceSettings.stateInformation = new CECStateInformation[this.machineCount];
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "SurveillanceBean.saveChoices2() about to set surveillance states");
            }
            for (int i = 0; i < this.machineCount; ++i) {
                CECStateInformation cECStateInformation = new CECStateInformation();
                ItemDescriptor[] itemDescriptorArray = this.getUTM().getRow(this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME, i);
                String string = itemDescriptorArray[2].getTitle();
                int n = string.indexOf("/");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                cECStateInformation.machineModelType = string2;
                cECStateInformation.machineSerial = string3;
                cECStateInformation.machineName = itemDescriptorArray[0].getTitle();
                cECStateInformation.surveillanceState = itemDescriptorArray[1].getTitle();
                this.surveillanceSettings.stateInformation[i] = cECStateInformation;
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SurveillanceBean.saveChoices2() caught Exception" + exception);
                Trace.trace(TRACE_MASKF, "SurveillanceBean.saveChoices2() throwing SFPException");
            }
            throw new SFPException("1100", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceBean.saveChoices2()");
        }
    }

    public void load() {
    }

    public void populateChoices1() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SurveillanceBean.populateChoices1()");
            Trace.trace(TRACE_MASKT, "SFPSettingsInformation is " + this.surveillanceSettings);
            Trace.trace(TRACE_MASKT, "stateInformation is " + this.surveillanceSettings.stateInformation);
        }
        try {
            CECStateInformation[] cECStateInformationArray = this.surveillanceSettings.stateInformation;
            this.machineCount = cECStateInformationArray.length;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "SurveillanceBean.populateChoices1() Number of entries in CEC table is " + this.machineCount);
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Timer settings: \n disconnect:" + this.surveillanceSettings.disconnected);
                Trace.trace(TRACE_MASKD, "\n connected: " + this.surveillanceSettings.connected);
                Trace.trace(TRACE_MASKD, "\n interval: " + this.surveillanceSettings.interval);
            }
            this.getUTM().setValue(this.getMountPrefix() + SURVEILLANCE_DISCONNECTED_NAME, Integer.toString(this.surveillanceSettings.disconnected));
            this.initialDisconnected = this.surveillanceSettings.disconnected;
            this.getUTM().setValue(this.getMountPrefix() + SURVEILLANCE_CONNECTED_NAME, Integer.toString(this.surveillanceSettings.connected));
            this.initialConnected = this.surveillanceSettings.connected;
            this.getUTM().setValue(this.getMountPrefix() + SURVEILLANCE_INTERVAL_NAME, Integer.toString(this.surveillanceSettings.interval));
            this.initialInterval = this.surveillanceSettings.interval;
            this.getUTM().refreshAllElements();
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SurveillanceBean.populateChoices1() caught Exception: " + exception);
            }
            throw new SFPException("1100", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SurveillanceBean.populateChoices1()");
        }
    }

    public void populateChoices2() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SurveillanceBean.populateChoices2()");
            Trace.trace(TRACE_MASKT, "SFPSettingsInformation is " + this.surveillanceSettings);
            Trace.trace(TRACE_MASKT, "stateInformation is " + this.surveillanceSettings.stateInformation);
        }
        try {
            CECStateInformation[] cECStateInformationArray = this.surveillanceSettings.stateInformation;
            this.machineCount = cECStateInformationArray.length;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "SurveillanceBean.populateChoices2() Number of entries in CEC table is " + this.machineCount);
            }
            for (int i = 0; i < this.machineCount; ++i) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "SurveillanceBean.populateChoices2() populating Surveillance Table: " + i);
                }
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[]{new ItemDescriptor("SurveillanceCECTable." + i + "." + 0, cECStateInformationArray[i].machineName), cECStateInformationArray[i].surveillanceState.equals(ENABLED_EN_US) ? new ItemDescriptor("SurveillanceCECTable." + i + "." + 1, this.ENABLED_LABEL) : new ItemDescriptor("SurveillanceCECTable." + i + "." + 1, this.DISABLED_LABEL), new ItemDescriptor("SurveillanceCECTable." + i + "." + 2, cECStateInformationArray[i].getMachineId())};
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "SurveillanceBean.populateChoices2()adding row " + i + " to " + this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME);
                }
                this.getUTM().addRow(this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME, i, itemDescriptorArray);
            }
            this.getUTM().refreshAllElements();
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SurveillanceBean.populateChoices2() caught Exception: " + exception);
            }
            throw new SFPException("1101", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SurveillanceBean.populateChoices2()");
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        block18: {
            if (Trace.LEVEL >= 1) {
                Trace.trace(TRACE_MASKT, "->panelAction() : \n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
            }
            UserTaskManager userTaskManager = this.getUserTaskManager();
            String string = taskActionEvent.getElementName();
            if (string.equals(this.getMountPrefix() + "Button1")) {
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Enable button pressed");
                }
            } else if (string.equals(this.getMountPrefix() + "Button2")) {
                if (Trace.LEVEL >= 2) {
                    Trace.trace(TRACE_MASKF, "Disable button pressed");
                }
            } else {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                }
                new AusMicrocodeLog(LOG_INFO, 1).writeEntryFromTaskletClient();
                if (Trace.LEVEL >= 1) {
                    Trace.trace(TRACE_MASKT, "<-panelAction(logged error)");
                }
                return;
            }
            int[] nArray = this.getUTM().getSelectedRows(this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME);
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "Number of rows in table is " + this.surveillanceSettings.stateInformation.length);
                Trace.trace(TRACE_MASKD, "Number of rows selected is " + nArray.length);
            }
            for (int i = 0; i < nArray.length; ++i) {
                CECStateInformation cECStateInformation = this.surveillanceSettings.stateInformation[i];
                cECStateInformation.surveillanceState = string.equals(this.getMountPrefix() + "Button1") ? ENABLED_EN_US : DISABLED_EN_US;
                this.surveillanceSettings.pendingChanges = true;
                if (Trace.LEVEL < 3) continue;
                Trace.trace(TRACE_MASKD, "Machine " + cECStateInformation.machineName + " updated state to " + cECStateInformation.surveillanceState);
            }
            try {
                CECStateInformation[] cECStateInformationArray = this.surveillanceSettings.stateInformation;
                this.machineCount = cECStateInformationArray.length;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "SurveillanceBean.panelAction() Number of entries in CEC table is " + this.machineCount);
                }
                for (int i = 0; i < this.machineCount; ++i) {
                    if (3 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "SurveillanceBean.panelAction() populating Surveillance Table: " + i);
                    }
                    ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[]{new ItemDescriptor("SurveillanceCECTable." + i + "." + 0, cECStateInformationArray[i].machineName), new ItemDescriptor("SurveillanceCECTable." + i + "." + 1, cECStateInformationArray[i].surveillanceState), new ItemDescriptor("SurveillanceCECTable." + i + "." + 2, cECStateInformationArray[i].getMachineId())};
                    if (3 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "SurveillanceBean.panelAction()adding row " + i + " to " + this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME);
                    }
                    this.getUTM().removeRow(this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME, i);
                    this.getUTM().addRow(this.getMountPrefix() + SURVEILLANCE_CEC_TABLE_NAME, i, itemDescriptorArray);
                }
                this.getUTM().refreshAllElements();
            }
            catch (Exception exception) {
                if (1 > Trace.LEVEL) break block18;
                Trace.trace(TRACE_MASKT, "<-SurveillanceBean.panelAction() caught Exception: " + exception);
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-panelAction(...)");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->SurveillanceBean.nextButtonHit()");
        }
        try {
            this.getUTM().storeAllElements();
            if (this.surveillanceSettings.panelName.equals("SFPLanSurveillance1")) {
                this.saveChoices1();
            } else {
                this.saveChoices2();
            }
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SurveillanceBean.saveChoices() caught SFPException: " + sFPException.toString());
            }
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SURVEILLANCE_TASK_EXTENSION", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", sFPException.getKey(), null));
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceBean.nextButtonHit()");
        }
        return this.surveillanceSettings;
    }

    public Serializable backButtonHit() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->SurveillanceBean.backButtonHit()");
        }
        return this.surveillanceSettings;
    }

    static {
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "->SurveillanceBean(static)");
        }
        Integer n = new Integer(0);
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "<-SurveillanceBean(static)");
        }
    }
}

